<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
# JUNIPER !! Host: $IP
# ########################################################################## !!

set interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC description $MAP_NAME
set interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC encapsulation vlan-bridge
set interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC vlan-id $VLAN_SRC
set interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family bridge policer input $MAP_NAME-IN
set interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family bridge policer output $MAP_NAME-OUT

set interfaces $INTERFACE_DST unit $SUBINTERFACE_DST description $INTERFACE_DESCRIPTION_DST
set interfaces $INTERFACE_DST unit $SUBINTERFACE_DST encapsulation vlan-bridge
set interfaces $INTERFACE_DST unit $SUBINTERFACE_DST vlan-id $VLAN_SRC
set interfaces $INTERFACE_DST unit $SUBINTERFACE_DST family bridge policer input $MAP_NAME-IN
set interfaces $INTERFACE_DST unit $SUBINTERFACE_DST family bridge policer output $MAP_NAME-OUT

set bridge-domains $VLAN_SRC description $MAP_NAME
set bridge-domains $VLAN_SRC domain-type bridge
set bridge-domains $VLAN_SRC vlan-id $VLAN_SRC
set bridge-domains $VLAN_SRC interface $INTERFACE_SRC.$SUBINTERFACE_SRC
set bridge-domains $VLAN_SRC interface $INTERFACE_DST.$SUBINTERFACE_DST

set firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
set firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10000
set firewall policer $MAP_NAME-IN then discard

set firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
set firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10000
set firewall policer $MAP_NAME-OUT then discard

";

}

?>
